*Size Distribution 1990

*-------------------------------------------------------
* Creating ks

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\ce.dta", clear

rename _1987 ce1987
rename _1988 ce1988
rename _1989 ce1989
rename _1990 ce1990
rename _1991 ce1991
rename _1992 ce1992
rename _1993 ce1993
rename _1994 ce1994
rename _1995 ce1995
rename _1996 ce1996
rename _1997 ce1997
rename _1998 ce1998
rename _1999 ce1999
rename _2000 ce2000
rename _2001 ce2001

sort sic
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks.dta", replace
use "C:\Documents and Settings\Proprio\My Documents\RA\USA\gdp.dta", clear
sort sic
merge sic using "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks.dta"

rename _1987 gdp1987
rename _1988 gdp1988
rename _1989 gdp1989
rename _1990 gdp1990
rename _1991 gdp1991
rename _1992 gdp1992
rename _1993 gdp1993
rename _1994 gdp1994
rename _1995 gdp1995
rename _1996 gdp1996
rename _1997 gdp1997
rename _1998 gdp1998
rename _1999 gdp1999
rename _2000 gdp2000
rename _2001 gdp2001
drop _merge
sort sic
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks.dta", replace
use "C:\Documents and Settings\Proprio\My Documents\RA\USA\adjustment.dta", clear
sort sic
merge sic using "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks.dta"
drop _merge

gen ks90 = 1-ce1990/gdp1990
gen ks90adj = ks90*adjustment

keep sic adjustment ks90 ks90adj

sort sic

save "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks90.dta", replace

*---------------------------------------------------------------------------
* Construct intest1990.dta

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\est1990.dta", clear
rename establishments est1990
rename establishment_size minsize

* Select SIC
drop if  sic=="0700"
drop if  sic=="0800"
drop if  sic=="0900"
drop if sic=="10--"
drop if  sic=="1500"
drop if  sic=="1600"
drop if  sic=="1700"
replace sic = "-1" if sic=="20--"
drop if  sic=="40--"
drop if  sic=="60--"
drop if  sic=="5000"
drop if  sic=="5100"
drop if  sic=="5200"
drop if  sic=="5300"
drop if  sic=="5400"
drop if  sic=="5500"
drop if  sic=="5600"
drop if  sic=="5700"
drop if  sic=="5800"
drop if  sic=="5900"
drop if  sic=="70--"
drop if sic=="99--"
replace sic = "709" if sic=="07--"
replace sic = "1517" if sic=="15--"
replace sic = "5051" if sic=="50--"
replace sic = "5259" if sic=="52--"
replace sic = "8489" if (sic=="8400")|(sic=="8700")|(sic=="8900")
collapse (sum) est1990 , by(sic minsize)

* Define size bins
replace minsize = "0" if minsize =="0 employees" 
drop if minsize=="Total"
replace minsize = "10000" if minsize =="10,000 or more employees" 
gen size = word(subinstr(minsize,"-"," -",. ),1)
replace size = subinstr(size,",","",. )
replace size="10000" if minsize=="10000"
destring size, replace
drop minsize
gen minsize = size
drop if minsize == 0
drop size
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intest1990.dta", replace

replace sic = "0" if sic=="----"
destring sic, replace
sort sic minsize
fillin sic minsize
replace est1990 = 0 if est1990==.
sort sic minsize
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intest1990.dta", replace

*----------------------------------------------------------------
* Compute the total number of firms in every industry bin

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\intest1990.dta", clear
collapse (sum) est1990, by(sic)
rename est1990 tot
sort sic
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intesttotal1990.dta", replace

*----------------------------------------------------------------
* Merge the previous file with intest1990.dta

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\intest1990.dta", clear
sort sic
merge sic using "C:\Documents and Settings\Proprio\My Documents\RA\USA\intesttotal1990.dta"
drop _merge
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intP90.dta", replace

*----------------------------------------------------------------
* Compute Pj  = number of firms with size large than minsize in the same industry bin

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\intP90.dta", clear
sort sic minsize
gen Pj = tot
replace Pj = Pj[_n-1] - est1990[_n-1] if (sic[_n]==sic[_n-1])
replace Pj = Pj/tot
sort sic
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace
*----------------------------------------------------------------
*Merging ks90.dta and number of establishments

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks90.dta", clear
sort sic
merge sic using "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta"
drop _merge
sort sic minsize
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace

*-----------------------------------------------------------------
* Define regressions variables

keep if sic>100

gen lnPj = ln(Pj)
gen lsize = ln(minsize)
gen l2size = (ln(minsize))^2

gen ks90l2size = ks90*l2size
gen ks90adjl2size = ks90adj*l2size

xi: reg lnPj i.sic*lsize l2size ks90l2size if (ks90 <= 0.5)&(ks90 >=0)
xi: reg lnPj i.sic*lsize l2size ks90adjl2size if (ks90adj <= 0.5)&(ks90adj >=0)

save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace

*---------------------------------------------------------------------
*Figure 8 - 1990

gen avsize = 0
collapse avsize , by(minsize)
replace avsize = (minsize+minsize[_n+1] - 1)/2
replace avsize = 12500 if minsize==10000
sort minsize
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\figure81990.dta", replace
use "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", clear
sort minsize
merge minsize using "C:\Documents and Settings\Proprio\My Documents\RA\USA\figure81990.dta"
drop _merge

keep if ks90adj<0.5
keep if ks90adj>0
collapse (sd) avsize [aw=est1990],by(ks90adj)
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\figure81990.dta", replace


